	.include	'eq.s'
	.include	'externs.s'

	.text
go_intro::						;display something while graphics are being decompressed
	jsr		clearscr

;	bsr		ld_decmp				;load decompression GPU code
;	move.l	#q65,a3
;	bsr		load_dq

	bsr		ld_build

	bsr		clrinttx
	bsr		int_txt

	move.l	#intobjs,FIRSTOBJ_ADR	;address of first object header
	move.l	#INTRO_OBJS,TOTOBJS_ADR	;total objects in list
	bsr		do_build				;build packed object list
	jmp		startlev				;load level info

clrinttx::
	move.l	#PITCH1|PIXEL32|WID32|XADDPHR,A1_FLAGS
	move.l	#screenpad+(128*152*2),A1_BASE			;destination address
	move.l	#0,A1_PIXEL				;get rectangle Y,X
	move.l	#$0001FFE0,A1_STEP			;high = Y step, low = negative width
	move.l	#$00070020,B_COUNT			;high = height, low = width
	move.l	#$0,B_PATD				;write FF's for 1 bit per pixel object
	move.l	#$0,B_PATD+4
	move.l	#PATDSEL|UPDA1,B_CMD
	rts

int_txt::
	move.w	level,d0				;levelx4 has not been set yet
	lsl.w	#2,d0
	lea		int_strs,a0			;list of strings for each level
	move.l	(a0,d0.w),a0			;address of string for next level
	move.l	#$00000000,d5			;Y,X position of first char
	bsr		blitint
	rts


blitint::
	move.l	#PITCH1|PIXEL8|WID128|XADDPIX,A1_FLAGS	;description of destination area
	move.l	#screenpad+(128*152*2),A1_BASE					;destination address
	move.l	#PITCH1|PIXEL8|XADDPIX,A2_FLAGS		;description of source data
	move.l	#$0001FFFA,A1_STEP					;1 in Y step, negative width in X step size
.10:	clr.l	d0
	move.b	(a0)+,d0				;get the character
	cmp.b	#0,d0				;0 is end of string data
	beq.b	.90
	cmp.b	#' ',d0				;blank space
	beq.b	.50
	lea		fontaddr,a5
	sub.b	#'!',d0				;the first valid character
	lsl.w	#2,d0				;4 bytes per character address
	move.l	(a5,d0.w),d7			;address of current character data
	bsr		blit_chr
.50:	add.l	#$00000006,d5			;add width of a character + 1 pixel
	bra.b	.10
.90:	rts

int_strs::
	dc.l		int_spc,int_des
	dc.l		int_spc,int_cave
	dc.l		int_spc,int_air
	dc.l		int_spc,int_yang
	dc.l		int_spc,int_city
	dc.l		int_bon

int_spc::		dc.b		'SPACE'
			dc.b		0
int_des::		dc.b		'OSSEOUS'
			dc.b		0
int_air::		dc.b		'ZEPHYRITE'
			dc.b		0
int_cave::	dc.b		'GROTTONERIA'
			dc.b		0
int_yang::	dc.b		'EQUILIBRIUMITE'
			dc.b		0
int_city::	dc.b		'COSMOLITE'
			dc.b		0
int_bon::		dc.b		'BONUS LEVEL'
			dc.b		0

	.even
intolst::
;introscr::
	dc.b		0			;type
	dc.b		0			;depth
	dc.w		0			;xpos	
	dc.w		SCRN_TOP		;ypos
	dc.w		288			;height
	dc.w		1			;dwidth
	dc.w		7			;iwidth
	dc.l		specdata		;data
	dc.b		0			;flags
	dc.b		0			;firstpix
	dc.b		0			;pitch	repeat same phrase of data 7 times
	dc.b		119			;index  use colors $EE,$EF
	dc.l		0			;desc
	dc.l		$00202020		;unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;introtxt::
	dc.b		0			; o_type
	dc.b		3			; o_depth
	dc.w		250			;xpos	
	dc.w		SCRN_TOP+200	;ypos
	dc.w		7			; o_height
	dc.w		16			; o_dwidth
	dc.w		16			; o_iwidth
	dc.l		screenpad+(128*152*2)		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00202020		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;inticons::
	dc.b		0			; o_type
	dc.b		3			; o_depth
	dc.w		ICON_XPOS		;xpos	
	dc.w		ICON_YPOS		;ypos
	dc.w		15			; o_height
	dc.w		10			; o_dwidth
	dc.w		10			; o_iwidth
	dc.l		iconbar		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00202020		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------
;intscor::
	dc.b		0			; o_type	Bit Mapped type
	dc.b		3			; o_depth
	dc.w		SCORE_XPOS	;xpos	
	dc.w		SCORE_YPOS	;ypos
	dc.w		12			; o_height
	dc.w		10			; o_dwidth
	dc.w		10			; o_iwidth
	dc.l		scorebar		; o_data
	dc.b		TRANS_ON		; o_flags
	dc.b		0			; o_firstpix
	dc.b		1			; o_pitch
	dc.b		0			; o_index
	dc.l		0			; o_desc
	dc.l		$00202020		; unused byte, remainder, vscale, hscale
;---------------------------------------------------------------------

